**********************************************************************
*This program produce estimates of redraw account balances with the loan-level data 
**********************************************************************
clear
*import combined loan-level data
use "$path\rawdata\loan.dta"
*use $path\data\loan_HES.dta" to create "$path\data\redraw_HES.dta" 

*merge indicator interest rates

*average_rate  is average annual 3 year OO fixed loan rate 
*ir_1-30  are interest rates for each year of loan's life for loans originated in different years

merge m:m year using "$path\rawdata\F5.dta" , nogen 

g mortgage_type = 0
replace mortgage_type = 1 if (mpurl == 1 | mpurl == 3)
replace mortgage_type = 2 if (mpurl == 2 | mpurl == 4)

*get rid of other types of loans 
drop if mortgage_type ==0

gen loan_age = year - year_loan_originated


drop if loan_age > 30
*drop if loan_age < 2

//remaining term in months
gen n = (30-loan_age) * 12

gen loan_age_months = loan_age * 12


*create monthly interest rate from annual interest rate
forvalues i=1/12{
gen ir_month_`i'=ir_1
}

forvalues i=13/24{
gen ir_month_`i'=ir_2
}

forvalues i=25/36{
gen ir_month_`i'=ir_3
}

forvalues i=37/48{
gen ir_month_`i'=ir_4
}

forvalues i=49/60{
gen ir_month_`i'=ir_5
}

forvalues i=61/72{
gen ir_month_`i'=ir_6
}

forvalues i=73/84{
gen ir_month_`i'=ir_7
}

forvalues i=85/96{
gen ir_month_`i'=ir_8
}

forvalues i=97/108{
gen ir_month_`i'=ir_9
}

forvalues i=109/120{
gen ir_month_`i'=ir_10
}

forvalues i=121/132{
gen ir_month_`i'=ir_11
}

forvalues i=133/144{
gen ir_month_`i'=ir_12
}

forvalues i=145/156{
gen ir_month_`i'=ir_13
}

forvalues i=157/168{
gen ir_month_`i'=ir_14
}

forvalues i=169/180{
gen ir_month_`i'=ir_15
}

forvalues i=181/192{
gen ir_month_`i'=ir_16
}

forvalues i=193/204{
gen ir_month_`i'=ir_17
}

forvalues i=205/216{
gen ir_month_`i'=ir_18
}

forvalues i=217/228{
gen ir_month_`i'=ir_19
}

forvalues i=229/240{
gen ir_month_`i'=ir_20
}

forvalues i=241/252{
gen ir_month_`i'=ir_21
}

forvalues i=253/264{
gen ir_month_`i'=ir_22
}

forvalues i=265/276{
gen ir_month_`i'=ir_23
}

forvalues i=277/288{
gen ir_month_`i'=ir_24
}

forvalues i=289/300{
gen ir_month_`i'=ir_25
}

forvalues i=301/312{
gen ir_month_`i'=ir_26
}

forvalues i=313/324{
gen ir_month_`i'=ir_27
}

forvalues i=325/336{
gen ir_month_`i'=ir_28
}

forvalues i=337/348{
gen ir_month_`i'=ir_29
}

forvalues i=349/360{
gen ir_month_`i'=ir_30
}


* calculate scheduled balance for each month of a loan's life for a credit-foncier loan 
* assume loan term is 30 years (360 months)
* assume PI
* adjust interst rate over time in line with indicator rate (OO 3-year fixed rate)


* set scheduled balance at t=0 equal to amount borrowed 
gen scheduled_balance_0=L_borrow


* total scheduled payment=L×intrate*((1+i)^360-1) *〖intrate*[(1+intrate)^360-1]〗^(-1)
* interest payment= interest rate *scheduled balance in previous period
* principal payment = total scheduled payment - interest payment 
* scheduled balance = scheduled balance in previous period - principal payment 

*the loop calculates scheduled balance from t=0 to 360 months 
forvalues i=1/360{

local j=`i' -1


gen total_mortgage_payment_`i' = L_borrow / ((((1 + ir_month_`i'/1200)^360) - 1) / (ir_month_`i'/1200*((1 + ir_month_`i'/1200)^360)))
gen interest_payment_`i'=ir_month_`i'/1200*scheduled_balance_`j' 

gen principal_payment_`i'=total_mortgage_payment_`i'-interest_payment_`i' 

gen scheduled_balance_`i'=scheduled_balance_`j'-principal_payment_`i' 

}

* calculate estimated current scheduled balance (scheduled_balance_n, where n is loan age in months)
forvalues i=1/360{
gen estimated_balance_`i'=scheduled_balance_`i' if `i'==loan_age_months
}

order *, sequential

egen estimated_balance_remaining= rowmax(estimated_balance_1-estimated_balance_360)

* redraw = estimated scheduled balance - loan outstanding
gen redraw= estimated_balance_remaining - L


*identify interest only loans 
gen io_loan = 0
replace io_loan=1 if L==L_borrow

*create redraw values for p&i loans 
gen estimated_balance_remaining_pi=estimated_balance_remaining if io_loan==0
gen L_pi=L if io_loan==0


replace redraw=0 if io_loan==1
replace redraw=0 if redraw<0

gen behind_schedule=0
replace behind_schedule=1 if redraw<0

*hh_redraw is the sum of all redraw accounts held by a household
sort abshid
by abshid: gen hh_redraw=sum(redraw)
keep if mortgage_type==1

sort abshid
by abshid:  gen dup_hh = cond(_N==1,0,_n)
drop if dup_hh>1
drop dup_hh

keep abshid abslid hh_redraw redraw estimated_balance_remaining behind_schedule year mortgage_type year_loan_originated L L_borrow curintl loan_age
save "$path\data\redraw.dta" 






















